//
//  BIReportTemplatePreference+BIReportsAdditions.h
//  BIReports
//
//  Created by Alykhan Jetha on 10-05-21.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <BISubstrate/BIReportTemplatePreference.h>

@class MCReportWrapper;

@interface BIReportTemplatePreference (BIReportsAdditions)

/*!
 Encodes and decodes the config dictionary. Trasient, so keep the dict around instead of calling this multiple times.
 */
- (NSMutableDictionary *)configurationDictionary;
- (void)setConfigurationDictionary:(NSDictionary *)value;

/*!
 Returns the report wrapper based wether it is in database or on disk. Returns nil if not found.
 */
- (MCReportWrapper *)reportWrapper;

/*!
 Given a report wrapper, sets the name or appropriate report template
 */
- (void)setReportWrapper:(MCReportWrapper *)aWrapper;
@end
